<?php 
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * l/inee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */
	
    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/GeneratoreForm.php";
    include "template/include/includeClassiTemplate.php";
        
    $geecomDb = new DbManager($costantiDatabase);	
    $impostazioni = recuperaImpostazioni($geecomDb);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataAdmin");
    
    $query = "SELECT * FROM geecAd_comunicazioni WHERE tipo LIKE 'footer'";
    $risQuery = $geecomDb->eseguiQueryLettura($query);
    $footer = $risQuery->fetch_assoc();

    session_start();
    if(isset($_SESSION["geecomUser_email"])) {
        header("Location: pagina.php?id={$impostazioni["homeUtente"]}");
    }
    else {
        $_SESSION["tokenSicurezza"] = sha1(rand(0,10000));
    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="generator" content="Geecom Admin"/>

    <title><?php echo $impostazioni["nomePiattaforma"]; ?> - recupera password</title>

    <!-- Favicon-->
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <!-- Favicon-->
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="plugins/bootstrap/bootstrap.min.css">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.9/css/all.css" integrity="sha384-5SOiIsAziJl6AWe0HWRKTXlfcSHKmYV4RBF18PPJ173Kzn7jzMyFuTtk8JA7QQG1" crossorigin="anonymous">

    <!-- Password strength meter -->
    <link rel="stylesheet" href="../plugins/password-strength-meter-1.1.0/dist/password.min.css">

    <?php
        UtilTemplate::stampaRoot($configurazioneAspetto);
    ?>
    <!-- Custom CSS -->
    <link rel="stylesheet" href="template/css/StileBackend.css">
</head>

<body class="bg-primary">
    <main role="main"  class="d-flex align-items-center mt-0">
        <div id="login" class="container">
            <div class="card card-container box-shadow-lite fadeInDown">
		<a href="index.php">
                    <img class="img-fluid mb-4" src="<?php echo $configurazioneAspetto["logo"]; ?>" />
                </a>
                    <?php 
                        if(isset($_GET["status"])) {
                                if($_GET["status"]==100) {
                                    echo"<p class=\"alert alert-success\">È stata inviata un'email all'indirizzo specificato</p>";
                                }           	
                                else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Errore: indirizzo email non trovato</p>";
                                }
                                else { //status = 444
                                    echo"<p class=\"alert alert-danger\">Errore: Il token di sicurezza non era più valido, riprova ora</p>";
                                }
                        }
                    ?>
                <div class="mb-2">
                    Inserisci il tuo indirizzo email per recuperare la password
                </div>
                    <form role="form" name="formRecuperaPassword" action=utenti/inviaMailRecupero.php method="post" > 
                        <div class="form-group">
                            <input type="email" name="email" id="inputEmail" class="form-control" placeholder="Indirizzo email" required autofocus>
                        </div>
                        <input type="text" class="d-none" name="tokenSicurezza" <?php echo"value=\"{$_SESSION["tokenSicurezza"]}\""; ?> />

                        <button class="btn btn-primary btn-block" type="submit">Recupera password </button>
                    </form>
            </div>
        </div>
    </main>
    

    
    <script src="js/util.js"></script>
    <script src="template/plugins/jquery/jquery.min.js"></script>

    <!-- Bootstrap Core Js -->
    <script src="template/plugins/bootstrap/js/bootstrap.js"></script>
    
    <!-- Select Plugin Js -->
    <script src="template/plugins/bootstrap-select/js/bootstrap-select.js"></script>

    <!-- Slimscroll Plugin Js -->
    <script src="template/plugins/jquery-slimscroll/jquery.slimscroll.js"></script>

    <!-- Bootstrap Colorpicker Js -->
    <script src="template/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.js"></script>

    <!-- Dropzone Plugin Js -->
    <script src="template/plugins/dropzone/dropzone.js"></script>

    <!-- Input Mask Plugin Js -->
    <script src="template/plugins/jquery-inputmask/jquery.inputmask.bundle.js"></script>

    <!-- Multi Select Plugin Js -->
    <script src="template/plugins/multi-select/js/jquery.multi-select.js"></script>

    <!-- Jquery Spinner Plugin Js -->
    <script src="template/plugins/jquery-spinner/js/jquery.spinner.js"></script>

    <!-- Bootstrap Tags Input Plugin Js -->
    <script src="template/plugins/bootstrap-tagsinput/bootstrap-tagsinput.js"></script>

    <!-- noUISlider Plugin Js -->
    <script src="template/plugins/nouislider/nouislider.js"></script>

    <!-- Waves Effect Plugin Js -->
    <script src="template/plugins/node-waves/waves.js"></script>

    <!-- Custom Js -->
    <script src="template/js/admin.js"></script>
    <script src="template/js/advanced-form-elements.js"></script>
    
    <!-- Demo Js -->
    <script src="template/js/demo.js"></script>
        
        <!-- Stabilisce il numero massimo di immagini caricabili -->
        <script>
		$(".cover-image").dropzone({
			maxFiles: 1,
			maxfilesexceeded: function(file) {
				this.removeAllFiles();
				this.addFile(file);
			}
		})  
		
		$(".galleria").dropzone({
			maxFiles: 10,
			maxfilesexceeded: function(file) {
				this.removeAllFiles();
				this.addFile(file);
			}
		})		     
		 </script>
         
         <!-- Tooltips -->
		<script>
        $(function () {
		  $("[data-toggle=popover]").popover();
		})
        </script>

</body>

</html>
